/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon.evolution;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.EvolvePokemonContext;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonGainedEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionCompleteEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionTestedEvent;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionLike;
import com.cobblemon.mod.common.api.pokemon.evolution.PassiveEvolution;
import com.cobblemon.mod.common.api.pokemon.evolution.PreEvolution;
import com.cobblemon.mod.common.api.pokemon.requirement.Requirement;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u001c\u0010\u001c\u001a\u00020\u00048&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001f\u001a\u00020\u00048&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020%0 8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u0014\u0010+\u001a\u00020(8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006,\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/evolution/Evolution;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionLike;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "test", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "evolve", "shed", "", "forceEvolve", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/class_1297;", "evolutionAnimation", "(Lnet/minecraft/class_1297;)V", "cryAnimation", "evolutionMethod", "applyTo", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getResult", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "result", "getShedder", "shedder", "getOptional", "()Z", "setOptional", "(Z)V", "optional", "getConsumeHeldItem", "setConsumeHeldItem", "consumeHeldItem", "", "Lcom/cobblemon/mod/common/api/pokemon/requirement/Requirement;", "getRequirements", "()Ljava/util/Set;", "requirements", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getLearnableMoves", "learnableMoves", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "getDrops", "()Lcom/cobblemon/mod/common/api/drop/DropTable;", "drops", "common"})
@SourceDebugExtension(value={"SMAP\nEvolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Evolution.kt\ncom/cobblemon/mod/common/api/pokemon/evolution/Evolution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,251:1\n1740#2,3:252\n808#2,11:264\n1869#2,2:275\n808#2,11:277\n1869#2,2:288\n1869#2:308\n1761#2,3:309\n1870#2:312\n14#3,5:255\n19#3:263\n14#3,5:290\n19#3:298\n14#3,5:299\n19#3:307\n13805#4:260\n13806#4:262\n13805#4:295\n13806#4:297\n13805#4:304\n13806#4:306\n14#5:261\n14#5:296\n14#5:305\n*S KotlinDebug\n*F\n+ 1 Evolution.kt\ncom/cobblemon/mod/common/api/pokemon/evolution/Evolution\n*L\n95#1:252,3\n227#1:264,11\n227#1:275,2\n228#1:277,11\n228#1:288,2\n209#1:308\n217#1:309,3\n209#1:312\n97#1:255,5\n97#1:263\n243#1:290,5\n243#1:298\n244#1:299,5\n244#1:307\n97#1:260\n97#1:262\n243#1:295\n243#1:297\n244#1:304\n244#1:306\n97#1:261\n243#1:296\n244#1:305\n*E\n"})
public interface Evolution
extends EvolutionLike {
    @NotNull
    public PokemonProperties getResult();

    @Nullable
    public PokemonProperties getShedder();

    public boolean getOptional();

    public void setOptional(boolean var1);

    public boolean getConsumeHeldItem();

    public void setConsumeHeldItem(boolean var1);

    @NotNull
    public Set<Requirement> getRequirements();

    @NotNull
    public Set<MoveTemplate> getLearnableMoves();

    @NotNull
    public DropTable getDrops();

    /*
     * WARNING - void declaration
     */
    default public boolean test(@NotNull Pokemon pokemon) {
        void $this$iv;
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Iterable $this$all$iv = this.getRequirements();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Requirement requirement = (Requirement)element$iv;
                    boolean bl2 = false;
                    if (requirement.check(pokemon)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean result = bl;
        EvolutionTestedEvent event = new EvolutionTestedEvent(pokemon, this, result, result);
        EventObservable<EvolutionTestedEvent> $i$f$all = CobblemonEvents.EVOLUTION_TESTED;
        EvolutionTestedEvent[] evolutionTestedEventArray = new EvolutionTestedEvent[]{event};
        EvolutionTestedEvent[] events$iv = evolutionTestedEventArray;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        EvolutionTestedEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            EvolutionTestedEvent element$iv$iv;
            EvolutionTestedEvent evolutionTestedEvent = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl3 = false;
            EvolutionTestedEvent it = evolutionTestedEvent;
        }
        return event.getResult();
    }

    default public boolean evolve(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (this.getConsumeHeldItem()) {
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            Pokemon.swapHeldItem$default(pokemon, class_17992, false, false, 6, null);
        }
        if (this.getOptional()) {
            return pokemon.getEvolutionProxy().server().add(this);
        }
        this.forceEvolve(pokemon);
        return true;
    }

    default public boolean shed(@NotNull Pokemon pokemon) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            PokemonProperties pokemonProperties = this.getShedder();
            if (pokemonProperties == null) {
                return false;
            }
            PokemonProperties innerShedder = pokemonProperties;
            class_3222 class_32222 = pokemon.getOwnerPlayer();
            if (class_32222 == null) {
                return false;
            }
            class_3222 owner = class_32222;
            class_1799 pokeballStack = null;
            if (!owner.method_56992()) {
                int n = owner.method_31548().method_5439();
                for (int i = 0; i < n; ++i) {
                    class_1799 stackI = owner.method_31548().method_5438(i);
                    if (!stackI.method_31573(CobblemonItemTags.POKE_BALLS)) continue;
                    pokeballStack = stackI;
                }
                if (pokeballStack == null) {
                    return false;
                }
            }
            if (PlayerExtensionsKt.party(owner).getFirstAvailablePosition() == null) {
                return false;
            }
            Pokemon shedPokemon = Pokemon.clone$default(pokemon, false, owner.method_56673(), 1, null);
            shedPokemon.removeHeldItem();
            innerShedder.apply(shedPokemon);
            class_1799 class_17992 = pokeballStack;
            if (class_17992 == null || (class_17992 = class_17992.method_7909()) == null) {
                class_17992 = CobblemonItems.POKE_BALL;
            }
            Intrinsics.checkNotNull((Object)class_17992, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.item.PokeBallItem");
            shedPokemon.setCaughtBall(((PokeBallItem)class_17992).getPokeBall());
            StoreCoordinates<?> storeCoordinates = pokemon.getStoreCoordinates().get();
            if (storeCoordinates != null && (storeCoordinates = storeCoordinates.getStore()) != null) {
                ((PokemonStore)((Object)storeCoordinates)).add(shedPokemon);
            }
            PreEvolution preEvolution = pokemon.getPreEvolution();
            Intrinsics.checkNotNull((Object)preEvolution);
            CobblemonCriteria.EVOLVE_POKEMON.trigger(owner, new EvolvePokemonContext(preEvolution.getSpecies().getResourceIdentifier(), shedPokemon.getSpecies().getResourceIdentifier(), Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(owner).getAdvancementData().getTotalEvolvedCount()));
            class_1799 class_17993 = pokeballStack;
            if (class_17993 == null) break block8;
            class_17993.method_57008(1, (class_1309)owner);
        }
        return true;
    }

    default public void forceEvolve(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        boolean useEvolutionEffect = true;
        if (pokemon.getState() instanceof ShoulderedState) {
            pokemon.tryRecallWithAnimation();
        }
        class_5250 preEvoName = Pokemon.getDisplayName$default(pokemon, false, 1, null);
        PokemonEntity pokemonEntity = pokemon.getEntity();
        if (pokemonEntity == null) {
            class_3222 class_32222 = pokemon.getOwnerPlayer();
            if (class_32222 != null) {
                class_32222.method_17356(CobblemonSounds.EVOLUTION_UI, class_3419.field_15248, 1.0f, 1.0f);
            }
            this.evolutionMethod(pokemon);
            class_3222 class_32223 = pokemon.getOwnerPlayer();
            if (class_32223 != null) {
                Object[] objectArray = new Object[]{preEvoName, pokemon.getSpecies().getTranslatedName()};
                class_32223.method_43496((class_2561)LocalizationUtilsKt.lang("ui.evolve.into", objectArray));
            }
        } else {
            pokemonEntity.method_5841().method_12778(PokemonEntity.Companion.getEVOLUTION_STARTED(), (Object)true);
            pokemonEntity.getNavigation().method_6340();
            pokemonEntity.after(1.0f, (Function0<Unit>)((Function0)() -> Evolution.forceEvolve$lambda$0(this, pokemonEntity)));
            pokemonEntity.after(11.2f, (Function0<Unit>)((Function0)() -> Evolution.forceEvolve$lambda$1(this, pokemon)));
            pokemonEntity.after(12.0f, (Function0<Unit>)((Function0)() -> Evolution.forceEvolve$lambda$2(this, pokemonEntity, pokemon, preEvoName)));
        }
    }

    private void evolutionAnimation(class_1297 pokemon) {
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemon.method_5628(), SetsKt.setOf((Object)"q.bedrock_stateful('evolution', 'evolution', 'endures_primary_animations');"), CollectionsKt.emptyList());
        NetworkPacket networkPacket = playPoseableAnimationPacket;
        double d = pokemon.method_23317();
        double d2 = pokemon.method_23318();
        double d3 = pokemon.method_23321();
        class_5321 class_53212 = pokemon.method_37908().method_27983();
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"dimension(...)");
        NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 128.0, class_53212, null, 32, null);
    }

    private void cryAnimation(class_1297 pokemon) {
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemon.method_5628(), SetsKt.setOf((Object)"cry"), CollectionsKt.emptyList());
        NetworkPacket networkPacket = playPoseableAnimationPacket;
        double d = pokemon.method_23317();
        double d2 = pokemon.method_23318();
        double d3 = pokemon.method_23321();
        class_5321 class_53212 = pokemon.method_37908().method_27983();
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"dimension(...)");
        NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 128.0, class_53212, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    default public void evolutionMethod(@NotNull Pokemon pokemon) {
        Object it;
        EventObservable<PokemonGainedEvent> $this$iv;
        void $this$forEach$iv;
        EvolutionCompleteEvent[] $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Iterable<MoveTemplate> previousSpeciesLearnableMoves = pokemon.getRelearnableMoves();
        Pokemon sourcePokemon = Pokemon.clone$default(pokemon, false, null, 3, null);
        this.getResult().apply(pokemon);
        List movesToLearn = CollectionsKt.plus(previousSpeciesLearnableMoves, (Iterable)this.getLearnableMoves());
        pokemon.getBenchedMoves().doWithoutEmitting((Function0<Unit>)((Function0)() -> Evolution.evolutionMethod$lambda$0(movesToLearn, pokemon, previousSpeciesLearnableMoves)));
        pokemon.getBenchedMoves().update();
        Iterable $this$filterIsInstance$iv = pokemon.getEvolutions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof PassiveEvolution)) continue;
            destination$iv$iv.add(t);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PassiveEvolution evolution = (PassiveEvolution)element$iv;
            boolean bl2 = false;
            evolution.attemptEvolution(pokemon);
        }
        $this$filterIsInstance$iv = pokemon.getLockedEvolutions();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof PassiveEvolution)) continue;
            destination$iv$iv.add(t);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            PassiveEvolution evolution = (PassiveEvolution)element$iv;
            boolean bl3 = false;
            evolution.attemptEvolution(pokemon);
        }
        this.shed(pokemon);
        class_3222 ownerPlayer = pokemon.getOwnerPlayer();
        if (ownerPlayer != null && ownerPlayer.method_37908().method_8450().method_8355(CobblemonGameRules.DO_POKEMON_LOOT)) {
            DropTable dropTable = this.getDrops();
            class_1309 class_13092 = (class_1309)pokemon.getEntity();
            class_1937 class_19372 = ownerPlayer.method_37908();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            class_3218 class_32182 = (class_3218)class_19372;
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity == null || (pokemonEntity = pokemonEntity.method_19538()) == null) {
                pokemonEntity = ownerPlayer.method_19538();
            }
            PokemonEntity $i$f$forEach22 = pokemonEntity;
            Intrinsics.checkNotNull((Object)$i$f$forEach22);
            DropTable.drop$default(dropTable, class_13092, class_32182, (class_243)$i$f$forEach22, ownerPlayer, null, pokemon, 16, null);
        }
        EventObservable<EvolutionCompleteEvent> $i$f$forEach22 = CobblemonEvents.EVOLUTION_COMPLETE;
        $this$filterIsInstanceTo$iv$iv = new EvolutionCompleteEvent[]{new EvolutionCompleteEvent(pokemon, sourcePokemon, this)};
        Object[] events$iv = $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        Object[] $this$forEach$iv$iv = events$iv;
        boolean bl = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            EvolutionCompleteEvent evolutionCompleteEvent = element$iv$iv;
            boolean bl2 = false;
            it = evolutionCompleteEvent;
        }
        $this$iv = CobblemonEvents.POKEMON_GAINED;
        events$iv = new PokemonGainedEvent[1];
        UUID uUID = pokemon.getOwnerUUID();
        Intrinsics.checkNotNull((Object)uUID);
        events$iv[0] = new PokemonGainedEvent(uUID, pokemon);
        $i$f$post = false;
        $this$iv.emit((PokemonGainedEvent[])Arrays.copyOf(events$iv, events$iv.length));
        $this$forEach$iv$iv = events$iv;
        boolean bl3 = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv$iv;
            it = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl4 = false;
        }
    }

    default public void applyTo(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.getResult().apply(pokemon);
    }

    private static Unit forceEvolve$lambda$0(Evolution this$0, PokemonEntity $pokemonEntity) {
        this$0.evolutionAnimation((class_1297)$pokemonEntity);
        return Unit.INSTANCE;
    }

    private static Unit forceEvolve$lambda$1(Evolution this$0, Pokemon $pokemon) {
        this$0.evolutionMethod($pokemon);
        return Unit.INSTANCE;
    }

    private static Unit forceEvolve$lambda$2(Evolution this$0, PokemonEntity $pokemonEntity, Pokemon $pokemon, class_5250 $preEvoName) {
        block0: {
            this$0.cryAnimation((class_1297)$pokemonEntity);
            $pokemonEntity.method_5841().method_12778(PokemonEntity.Companion.getEVOLUTION_STARTED(), (Object)false);
            class_3222 class_32222 = $pokemon.getOwnerPlayer();
            if (class_32222 == null) break block0;
            Object[] objectArray = new Object[]{$preEvoName, $pokemon.getSpecies().getTranslatedName()};
            class_32222.method_43496((class_2561)LocalizationUtilsKt.lang("ui.evolve.into", objectArray));
        }
        return Unit.INSTANCE;
    }

    private static Unit evolutionMethod$lambda$0(List $movesToLearn, Pokemon $pokemon, Iterable $previousSpeciesLearnableMoves) {
        Iterable $this$forEach$iv = $movesToLearn;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean previousSpeciesKnewMove;
            boolean couldAddMove;
            MoveTemplate move;
            block4: {
                move = (MoveTemplate)element$iv;
                boolean bl = false;
                couldAddMove = $pokemon.getMoveSet().hasSpace() ? $pokemon.getMoveSet().add(move.create()) : $pokemon.getBenchedMoves().add(new BenchedMove(move, 0));
                Iterable $this$any$iv = $previousSpeciesLearnableMoves;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        MoveTemplate it = (MoveTemplate)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)move.getName(), (Object)it.getName())) continue;
                        v0 = true;
                        break block4;
                    }
                    v0 = previousSpeciesKnewMove = false;
                }
            }
            if (!couldAddMove || previousSpeciesKnewMove) continue;
            class_3222 class_32222 = $pokemon.getOwnerPlayer();
            if (class_32222 == null) continue;
            Object[] objectArray = new Object[]{Pokemon.getDisplayName$default($pokemon, false, 1, null), move.getDisplayName()};
            class_32222.method_43496((class_2561)LocalizationUtilsKt.lang("experience.learned_move", objectArray));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static boolean test(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return $this.test(pokemon);
        }

        @Deprecated
        public static boolean evolve(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return $this.evolve(pokemon);
        }

        @Deprecated
        public static boolean shed(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return $this.shed(pokemon);
        }

        @Deprecated
        public static void forceEvolve(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            $this.forceEvolve(pokemon);
        }

        @Deprecated
        public static void evolutionMethod(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            $this.evolutionMethod(pokemon);
        }

        @Deprecated
        public static void applyTo(@NotNull Evolution $this, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            $this.applyTo(pokemon);
        }
    }
}

